<?php

use App\Http\Controllers\Admin\AboutController;
use App\Http\Controllers\Admin\AssociationController;
use App\Http\Controllers\Admin\AttributeController;
use App\Http\Controllers\Admin\AttributeGroupController;
use App\Http\Controllers\Admin\BrandController;
use App\Http\Controllers\Admin\ColorController;
use App\Http\Controllers\Admin\ContactController;
use App\Http\Controllers\Admin\CountryController;
use App\Http\Controllers\Admin\CouponController;
use App\Http\Controllers\Admin\DeliveryController;
use App\Http\Controllers\Admin\DeliveryOptionController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\ManagerController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\OutOfStockController;
use App\Http\Controllers\Admin\PaymentController;
use App\Http\Controllers\Admin\PermissionController;
use App\Http\Controllers\Admin\PlatformSettingController;
use App\Http\Controllers\Admin\ProductCategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\ReviewController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\SalesController;
use App\Http\Controllers\Admin\SellerController;
use App\Http\Controllers\Admin\SizeController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\WarehouseController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::post('test', function (Request $request) {

});
Route::resource('country', CountryController::class)
    ->only(['index', 'show', 'update'])->parameters(['country' => 'id']);
Route::resource('user', UserController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['user' => 'id']);
Route::get('about', [AboutController::class, 'index']);
Route::put('about', [AboutController::class, 'update']);
Route::resource('brand', BrandController::class)
    ->only(['index', 'show', 'store', 'update', 'patch', 'destroy'])->parameters(['brand' => 'id']);
Route::resource('coupon', CouponController::class)
    ->only(['index', 'store', 'destroy'])->parameters(['coupon' => 'code']);
Route::put('coupon', [CouponController::class, 'update']);
Route::resource('delivery', DeliveryController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['delivery' => 'id']);
Route::resource('deliveryOption', DeliveryOptionController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['deliveryOption' => 'id']);
Route::resource('faq', FAQController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['faq' => 'id']);
Route::resource('contact', ContactController::class)
    ->only(['index']);
Route::resource('productCategory', ProductCategoryController::class)
    ->only(['index', 'show', 'store', 'update', 'patch', 'destroy'])->parameters(['productCategory' => 'id']);
Route::get('permission', PermissionController::class);
Route::resource('role', RoleController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['role' => 'id']);
Route::resource('manager', ManagerController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['manager' => 'id']);
Route::resource('notification', NotificationController::class)
    ->only(['index', 'store', 'destroy']);
Route::resource('product', ProductController::class)
    ->only(['index', 'show', 'store', 'update', 'patch', 'destroy'])->parameters(['product' => 'id']);
Route::patch('updateFlashDeals/{id}', [ProductController::class, 'updateFlashDeals']);
Route::patch('updateBestCollection/{id}', [ProductController::class, 'updateBestCollection']);
Route::patch('updateNewlyAdded/{id}', [ProductController::class, 'updateNewlyAdded']);
Route::patch('updateSelected/{id}', [ProductController::class, 'updateSelected']);
Route::resource('outOfStock', OutOfStockController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['outOfStock' => 'id']);
Route::resource('productColor', ColorController::class)
    ->only(['store', 'update', 'destroy'])->parameters(['productColor' => 'id']);
Route::resource('productSize', SizeController::class)
    ->only(['store', 'update', 'destroy'])->parameters(['productColor' => 'id']);

Route::resource('attributeGroup', AttributeGroupController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['attributeGroup' => 'id']);
Route::resource('attribute', AttributeController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['attribute' => 'id']);
Route::resource('association', AssociationController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['association' => 'id']);
Route::resource('payment', PaymentController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['payment' => 'id']);
Route::get('salesSummary', [SalesController::class, 'summary']);
Route::get('salesChart', [SalesController::class, 'salesChart']);
Route::get('salesNewCustomers', [SalesController::class, 'newCustomers']);
Route::get('salesNewOrders', [SalesController::class, 'newOrders']);
Route::resource('review', ReviewController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['review' => 'id']);
Route::resource('order', OrderController::class)
    ->only(['index', 'show', 'destroy'])->parameters(['order' => 'id']);
Route::put('cancelOrder/{id}', [OrderController::class, 'cancel']);
Route::put('approveOrder/{id}', [OrderController::class, 'approve']);
Route::put('shipOrder', [OrderController::class, 'ship']);
Route::put('payOrder/{id}', [OrderController::class, 'paid']);
Route::put('refundOrder/{id}', [OrderController::class, 'refund']);
Route::put('markAsOngoing/{id}', [OrderController::class, 'markAsOngoing']);
Route::put('markAsDelivered/{id}', [OrderController::class, 'markAsDelivered']);
Route::put('assignOrderToDelivery', [OrderController::class, 'assignToDelivery']);
Route::resource('seller', SellerController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['seller' => 'id']);
Route::resource('warehouse', WarehouseController::class)
    ->only(['index', 'show', 'store', 'update', 'destroy'])->parameters(['warehouse' => 'id']);
Route::get('platformSettings', [PlatformSettingController::class, 'index']);
Route::put('platformSettings', [PlatformSettingController::class, 'update']);
Route::get('mainSliders',[\App\Http\Controllers\Admin\SliderController::class,'indexMain']);
Route::get('secSliders',[\App\Http\Controllers\Admin\SliderController::class,'indexSecondary']);
Route::get('slider/{slider}',[\App\Http\Controllers\Admin\SliderController::class,'show']);
Route::post('slider',[\App\Http\Controllers\Admin\SliderController::class,'store']);
Route::put('slider/{slider}',[\App\Http\Controllers\Admin\SliderController::class,'update']);
Route::delete('slider/{slider}',[\App\Http\Controllers\Admin\SliderController::class,'destroy']);
