<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCartItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cart_items', function (Blueprint $table) {
            $table->id();
            $table->timestamp('date')->nullable();
            $table->text('unit_name_en');
            $table->text('unit_name_ar');
            $table->json('unit_dimensions')->nullable();
            $table->float('unit_weight')->nullable();
            $table->float('unit_price', 12, 3);
            $table->json('unit_discount')->nullable();
            $table->json('unit_special_offer')->nullable();
            $table->json('unit_image')->nullable();
            $table->json('unit_color')->nullable();
            $table->json('unit_size')->nullable();

            $table->string('brand_name_en', 150);
            $table->string('brand_name_ar', 150);

            $table->boolean('purchased_with_points')->default(0);
            $table->bigInteger('points')->default(0);
            $table->float('tax', 12, 3);
            $table->float('total', 12, 3);
            $table->bigInteger('quantity')->default(1);
            $table->text('notes')->nullable();
            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->bigInteger('cart_id')->unsigned()->nullable();
            $table->foreign('cart_id')->references('id')->on('carts');
            $table->bigInteger('product_id')->unsigned()->nullable();
            $table->foreign('product_id')->references('id')->on('products');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cart_items');
    }
}
