<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->timestamp('date')->nullable();
            $table->text('number');
            $table->enum('state', ['new', 'approved', 'cancelled', 'assigned_to_delivery', 'ongoing', 'delivered']);
            $table->decimal('total', 30, 3);
            $table->decimal('subtotal', 30, 3);
            $table->decimal('tax', 30, 3)->default(0);
            $table->string('currency', 10);
            $table->unsignedInteger('total_quantity');
            $table->text('notes')->nullable();
            $table->decimal('discount_total', 30, 3);
            $table->decimal('coupon_total', 30, 3)->default(0);
            $table->boolean('deliverable')->default(false);
            $table->timestamp('delivery_assign_date')->nullable();
            $table->timestamp('delivered_date')->nullable();
            $table->enum('delivery_method', ['pickup', 'delivery']);
            $table->decimal('delivery_total', 30, 3)->default(0);
            $table->integer('delivery_time')->nullable();
            $table->integer('delivery_distance')->nullable();
            $table->boolean('post_process')->default(0);
            $table->text('post_url')->nullable();

            $table->enum('payment_state', ['awaiting', 'paid', 'refunded', 'cancelled']);
            $table->text('tap_token')->nullable();
            $table->text('tap_id')->nullable();
            $table->text('payment_platform')->nullable();
            $table->text('non_payment_reason')->nullable();
            $table->text('delivery_code')->nullable();

            $table->enum('shipping_state', ['ready', 'failed', 'shipped', 'cancelled'])->nullable();
            $table->timestamp('shipped_date')->nullable();
            $table->decimal('shipping_total', 30, 3)->default(0);
            $table->boolean('pruned')->default(0);
            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users');
            $table->bigInteger('delivery_id')->nullable()->unsigned();
            $table->foreign('delivery_id')->references('id')->on('users');
            $table->bigInteger('billing_address_id')->nullable()->unsigned();
            $table->foreign('billing_address_id')->references('id')->on('addresses');
            $table->bigInteger('shipping_address_id')->nullable()->unsigned();
            $table->foreign('shipping_address_id')->references('id')->on('addresses');
            $table->bigInteger('address_id')->nullable()->unsigned();
            $table->foreign('address_id')->references('id')->on('addresses');
            $table->bigInteger('seller_id')->nullable()->unsigned();
            $table->foreign('seller_id')->references('id')->on('sellers');
            $table->bigInteger('payment_id')->unsigned()->nullable();
            $table->foreign('payment_id')->references('id')->on('payments');
            $table->bigInteger('delivery_option_id')->unsigned()->nullable();
            $table->foreign('delivery_option_id')->references('id')->on('delivery_options');
            $table->bigInteger('coupon_id')->unsigned()->nullable();
            $table->foreign('coupon_id')->references('id')->on('coupons');
            $table->bigInteger('warehouse_id')->unsigned()->nullable();
            $table->foreign('warehouse_id')->references('id')->on('warehouses');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
}
