<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AssociationProduct extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('association_product', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('product_association_id')->unsigned()->default(1);
            $table->foreign('product_association_id')->references('id')->on('product_associations')->cascadeOnDelete();

            $table->bigInteger('product_id')->unsigned()->default(1);
            $table->foreign('product_id')->references('id')->on('products');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('association_product');
    }
}
