<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->text('code_group')->nullable();
            $table->text('title')->nullable();
            $table->text('body')->nullable();
            $table->string('code', 200);
            $table->unsignedInteger('percentage')->nullable();
            $table->float('amount')->nullable();
            $table->timestamp('creation')->nullable();
            $table->timestamp('expiration')->nullable();
            $table->boolean('active')->default(1);
            $table->boolean('used')->default(0);
            $table->string('timezone', 30);
            $table->boolean('for_marketing')->default(0);
            $table->boolean('on_delivery_cost')->default(0);

            $table->bigInteger('user_id')->nullable()->unsigned();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('CASCADE');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
