<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Throwable;

class SmsService
{
    public function send(string $mobileNumber, string $code, $locale = 'en')
    {
        try {
            $message = __('common.msg_sms_with_code', ['code' => $code], $locale);
            if (Str::startsWith($mobileNumber, '00')) {
                $mobileNumber = substr($mobileNumber, 2);
            }
            $response = Http::
            withHeaders([
                'Content-Type' => 'application/json'
            ])
                ->get(config('app.united_send_sms_url'), [
                    'api_key' => config('app.united_api_key'),
                    'sender_id' => config('app.united_sender_id'),
                    'send_type' => '1',
                    'sms_content' => $message,
                    'numbers' => $mobileNumber,
                ]);


            Log::channel('sms_report')->info("
          ############################ SMS Report ##############\n
          Mobile Number: $mobileNumber\n
          Code: $code\n
          Message: $message\n
          Locale: $locale\n
          --------------------------------------------\n\n
          Response Body:\n
          {$response->body()}\n\n
        ");

            return $response;

        } catch (Throwable $e) {
            Log::channel('sms_report')->info("
          ############################ SMS Report Fetal Error ##############\n
          Mobile Number: $mobileNumber\n
          Code: $code\n
          Message: $message\n
          Locale: $locale\n
          --------------------------------------------\n\n
          {$e->getMessage()}\n\n
          {$e->getLine()}\n\n
          {$e->getTraceAsString()}\n\n
        ");
            return null;
        }
    }

    public function balance()
    {
        return Http::
        withHeaders([
            'Content-Type' => 'application/json'
        ])
            ->get(config('app.united_get_balance_url'), [
                'api_key' => config('app.united_api_key')
            ]);
    }

    public function senderIDs()
    {
        return Http::
        withHeaders([
            'Content-Type' => 'application/json'
        ])
            ->get(config('app.united_get_sender_ids_url'), [
                'api_key' => config('app.united_api_key')
            ]);
    }
}
