<?php

namespace App\Services;

use Illuminate\Contracts\Mail\Mailable;
use Illuminate\Support\Facades\Mail;

class MailService
{
    public function sendToUser($user, Mailable $mailable)
    {
        if (!config('app.mail_enabled'))
            return;
        if ($user->appPreference->emails == '0') {
            return;
        }
        Mail::to($user->email)->send($mailable);
    }

    public function send($to, Mailable $mailable)
    {
        if (!config('app.mail_enabled'))
            return;
        Mail::to($to)->send($mailable);
    }

    public function sendToSupport(Mailable $mailable)
    {
        if (!config('app.mail_enabled'))
            return;
        Mail::to("support@" . explode('://', config('app.url'))[1])->send($mailable);
    }
}
