<?php

namespace App\Providers;

use App\Mail\OrderConfirmation;
use App\Services\MailService;
use App\Services\NotificationService;

class SendOrderNotifications
{
    private $notificationService;
    private $mailService;

    public function __construct(NotificationService $notificationService, MailService $mailService)
    {
        $this->notificationService = $notificationService;
        $this->mailService = $mailService;
    }

    /**
     * Handle the event.
     *
     * @param OrderPlaced $event
     * @return void
     */
    public function handle(OrderPlaced $event)
    {
        $this->notificationService->send(__('common.message_order_sent'), __('common.message_order_sent_body'), $event->order->user, [], NotificationService::ORDERS);
        $notificationData = [
            'role' => 'Super Admin',
            'title' => __('common.message_order_placed_title', ['fullname' => $event->order->user->full_name]),
            'body' => __('common.message_order_placed_body', ['fullname' => $event->order->user->full_name])
        ];
        $this->notificationService->sendToRole($event->order->user->timezone, NotificationService::ORDERS, $notificationData);
        /*if ($event->order->delivery_method != 'pickup') {
            $notificationData = [
                'role' => 'Delivery',
                'title' => __('common.message_order_placed_delivery_title', ['fullname' => $event->order->user->full_name]),
                'body' => __('common.message_order_placed_delivery_body', ['fullname' => $event->order->user->full_name])
            ];
            $this->notificationService->sendToRole($event->order->user->timezone, NotificationService::ORDERS, $notificationData);
        }*/
        $this->mailService->sendToUser($event->order->user, new OrderConfirmation($event->order));
    }
}
