<?php

namespace App\Models;

use App\Http\Traits\HasFile;
use App\Http\Traits\HasSort;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;

class Slider extends Model implements HasMedia
{
    use HasFile, HasSort,SoftDeletes;
    protected $hidden=['type'];
    protected $files=['image'];
    protected $guarded=['id'];
    public function category():BelongsTo
    {
        return $this->belongsTo(ProductCategory::class,'category_id','id');
    }

}
