<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ProductAssociation extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $hidden = ['association'];
    protected $appends = [
        'name_en',
        'name_ar'
    ];

    public function getNameEnAttribute()
    {
        return $this->association->name_en;
    }

    public function getNameArAttribute()
    {
        return $this->association->name_ar;
    }

    public function association(): BelongsTo
    {
        return $this->belongsTo(Association::class, 'association_id', 'id');
    }

    public function products(): BelongsToMany
    {
        return $this->belongsToMany(Product::class, 'association_product', 'product_association_id', 'product_id');
    }
}
