<?php

namespace App\Models;

use App\Http\Traits\HasCurrency;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

class OrderItem extends Model
{
    use HasFactory, SoftDeletes, HasCurrency;

    protected $guarded = ['id'];

    protected $casts = [
        'purchased_with_points' => 'boolean',
        'unit_dimensions' => 'array',
        'unit_discount' => 'array',
        'unit_special_offer' => 'array',
        'unit_image' => 'array',
        'unit_color' => 'array',
        'unit_size' => 'array',
    ];

    /*public function getUnitPriceAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getTaxAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getSubtotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getDiscountTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }

    public function getSpecialOfferTotalAttribute($value)
    {
        return $this->convertCurrency($value);
    }*/

    public function order(): BelongsTo
    {
        return $this->belongsTo(Order::class)->withTrashed();
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class)->withTrashed();
    }

    /**
     * @throws InvalidManipulation
     */
    public function registerMediaConversions(Media $media = null): void
    {
        $this->addMediaConversion('lq')
            ->quality(50)
            ->nonQueued()
            ->width(200)
            ->height(200);
    }
}
