<?php

namespace App\Models;

use App\Http\Traits\HasMediaImage;
use App\Http\Traits\HasSearch;
use App\Http\Traits\HasUniqueSoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\MediaLibrary\HasMedia;

class Brand extends Model implements HasMedia
{
    use HasFactory, SoftDeletes, HasSearch, HasMediaImage, HasUniqueSoftDeletes;

    protected $searchable = [
        'name_en',
        'name_ar',
    ];

    protected $guarded = ['id'];

    protected $casts = [
        'accepted' => 'boolean',
        'activated' => 'boolean',
        'image' => 'array',
        'special' => 'boolean'
    ];

    public function scopeActive($query, $active)
    {
        return $query->when($active !== null, function ($query) use ($active) {
            $query->where('activated', '=', boolval($active));
        });
    }

    public function scopeSpecial($query, $special)
    {
        return $query->when($special !== null, function ($query) use ($special) {
            $query->where('special', '=', $special == '1' || $special == 1 || $special == true || $special == 'true' ? '1' : '0');
        });
    }

    public function products(): HasMany
    {
        return $this->hasMany(Product::class);
    }
}
