<?php

namespace App\Listeners;

use App\Events\ProductSaved;
use App\Services\MailService;
use App\Services\NotificationService;

class NotifyProductSaved
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    private NotificationService $notificationService;
    private $mailService;

    public function __construct(NotificationService $notificationService, MailService $mailService)
    {
        $this->notificationService = $notificationService;
        $this->mailService = $mailService;
    }

    public function handle(ProductSaved $event): void
    {
        if (request()->filled('notification_title') && request()->filled('notification_body')) {
            $notificationData = [
                'role' => 'Member',
                'title' => request()->input('notification_title'),
                'body' => request()->input('notification_body')
            ];
            $this->notificationService->sendToRole($event->product->user->timezone, NotificationService::ORDERS, $notificationData);
        }
    }
}
