<?php


namespace App\Http\Traits;


use Intervention\Image\Facades\Image;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileCannotBeAdded;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Spatie\MediaLibrary\MediaCollections\Exceptions\InvalidBase64Data;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

trait ProductMedia
{
    use InteractsWithMedia;


    public static function bootProductMedia()
    {
        static::created(
        /**
         * @throws FileCannotBeAdded
         * @throws FileDoesNotExist
         * @throws FileIsTooBig
         * @throws InvalidBase64Data
         */
            function ($item) {
                // Image
                if (array_key_exists('image', $item->attributes)) {
                    if ($item->image === null || $item->image == '') {
                        $image = json_encode([
                            'low_quality' => config('app.url') . '/storage/default_image.jpg',
                            'high_quality' => config('app.url') . '/storage/default_image.jpg'
                        ]);
                    } else {
                        $media = $item
                            ->addMediaFromBase64((string)$item->image)
                            ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($item->image)->mime)[1])
                            ->toMediaCollection('product_image');
                        $image = json_encode([
                            'low_quality' => $media->getUrl('lq'),
                            'high_quality' => $media->getUrl()
                        ]);
                    }
                    $item->attributes['image'] = $image;
                }

                // Images
                if (array_key_exists('images', $item->attributes)) {
                    if ($item->images === null) {
                        $item->attributes['images'] = null;
                    } else {
                        if (is_array($item->images)) {
                            $images = [];
                            foreach ($item->images as $image) {
                                $m = $item
                                    ->addMediaFromBase64((string)$image)
                                    ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($image)->mime)[1])
                                    ->toMediaCollection('product_images');
                                array_push($images, [
                                    'low_quality' => $m->getUrl('lq'),
                                    'high_quality' => $m->getUrl()
                                ]);
                            }
                            $item->attributes['images'] = json_encode($images);
                        }
                    }
                }
                // Colors
                if (array_key_exists('colors', $item->attributes)) {
                    if ($item->colors === null) {
                        $item->attributes['colors'] = [];
                    } else {
                        if (is_array($item->colors)) {
                            $colors = [];
                            foreach ($item->colors as $color) {
                                $m = $item
                                    ->addMediaFromBase64((string)$color['image'])
                                    ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($color['image'])->mime)[1])
                                    ->toMediaCollection('product_colors');
                                $color['image'] = [
                                    'low_quality' => $m->getUrl('lq'),
                                    'high_quality' => $m->getUrl()
                                ];
                                array_push($colors, $color);
                            }
                            $item->attributes['colors'] = json_encode($colors);
                        }
                    }
                }
                $item->saveQuietly();
            });
        static::updating(/**
         * @throws FileCannotBeAdded
         * @throws FileIsTooBig
         * @throws FileDoesNotExist
         * @throws InvalidBase64Data
         */ function ($item) {
            // Image
            if (array_key_exists('image', $item->attributes)) {
                $value = $item->image;
                if ($value !== null && is_array($value) && array_search(config('app.url'), $value) !== null) {
                    $item->attributes['image'] = json_encode($value);
                } else {
                    if ($item->preserveMedia !== false) {
                        $item->getMedia('product_image')->map(function ($media) {
                            $media->delete();
                        });
                    }
                    if ($value === null || $value == '') {
                        $item->attributes['image'] = json_encode([
                            'low_quality' => config('app.url') . '/storage/default_image.jpg',
                            'high_quality' => config('app.url') . '/storage/default_image.jpg'
                        ]);
                    } else {
                        $media = $item
                            ->addMediaFromBase64($value)
                            ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($value)->mime)[1])
                            ->toMediaCollection('product_image');
                        $item->attributes['image'] = json_encode([
                            'low_quality' => $media->getUrl('lq'),
                            'high_quality' => $media->getUrl()
                        ]);
                    }

                }
            }
            // Images
            if (array_key_exists('images', $item->attributes)) {
                if ($item->images === null) {
                    $item->getMedia('images')->map(function ($media) {
                        $media->delete();
                    });
                    $item->attributes['images'] = null;
                } else {
                    $images = [];

                    if (is_array($item->images)) {
                        $existingImages = $item->getMedia('product_images');
                        $keep = [];
                        if (count($item->images) == 0) {
                            $existingImages->map(function ($media) {
                                $media->delete();
                            });
                        } else {
                            foreach ($item->images as $image) {
                                if (is_array($image)) {
                                    array_push($images, $image);
                                    array_push($keep, $image['high_quality']);
                                } else {
                                    $m = $item
                                        ->addMediaFromBase64((string)$image)
                                        ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($image)->mime)[1])
                                        ->toMediaCollection('product_images');
                                    array_push($images, [
                                        'low_quality' => $m->getUrl('lq'),
                                        'high_quality' => $m->getUrl()
                                    ]);
                                }
                            }

                        }
                        $existingImages->map(function ($media) use ($keep) {
                            if (!in_array($media->getUrl(), $keep)) {
                                $media->delete();
                            }
                        });

                        $item->attributes['images'] = json_encode($images);
                    }
                }
            }
        });
    }

    /**
     * @throws InvalidManipulation
     */
    public function registerMediaConversions(Media $media = null): void
    {
        $this->addMediaConversion('lq')
            ->quality(50)
            ->nonQueued()
            ->width(200)
            ->height(200);
    }
}
