<?php


namespace App\Http\Traits;

use Illuminate\Database\Eloquent\Builder;

/**
 * @method static Builder search(string $word)
 */
trait HasSearch
{
    public function scopeSearch($query, $word)
    {
        return $query->when($word !== null && $this->searchable !== null, function ($query) use ($word) {
            $query->where(function ($query) use ($word) {
                foreach ($this->searchable as $searchable) {
                    $query->orWhere($searchable, 'like', "%$word%");
                }
            });
        });
    }
}
