<?php


namespace App\Http\Traits;


use Illuminate\Support\Str;
use Intervention\Image\Facades\Image;
use Spatie\Image\Exceptions\InvalidManipulation;
use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileCannotBeAdded;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Spatie\MediaLibrary\MediaCollections\Exceptions\InvalidBase64Data;
use Spatie\MediaLibrary\MediaCollections\Models\Media;

trait HasMediaImage
{
    use InteractsWithMedia;

    public static function bootHasMediaImage()
    {
        static::created(
        /**
         * @throws FileCannotBeAdded
         * @throws FileDoesNotExist
         * @throws FileIsTooBig
         * @throws InvalidBase64Data
         */
            function ($item) {
                if (!array_key_exists('image', $item->attributes)) {
                    return;
                }
                if ($item->image === null || $item->image == '') {
                    if ($item->mediaImageWithDefaults != null && $item->mediaImageWithDefaults === false) {
                        $image = json_encode([]);
                    } else {
                        $image = json_encode([
                            'low_quality' => config('app.url') . '/storage/default_image.jpg',
                            'high_quality' => config('app.url') . '/storage/default_image.jpg'
                        ]);
                    }

                } else {
                    $media = $item
                        ->addMediaFromBase64((string)$item->image)
                        ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($item->image)->mime)[1])
                        ->toMediaCollection('image');
                    $image = json_encode([
                        'low_quality' => $media->getUrl('lq'),
                        'high_quality' => $media->getUrl()
                    ]);
                }
                $item->attributes['image'] = $image;
                $item->saveQuietly();
            });
        static::updating(/**
         * @throws FileCannotBeAdded
         * @throws FileIsTooBig
         * @throws FileDoesNotExist
         * @throws InvalidBase64Data
         */ function ($item) {
            if (!array_key_exists('image', $item->attributes)) {
                return;
            }

            $value = $item->image;
            if ($value !== null && is_array($value) && array_search(config('app.url'), $value) !== null) {
                $item->attributes['image'] = json_encode($value);
                return;
            }
            if (is_string($value) && Str::contains(Str::lower($value), 'talabatexpress.com')) {
                $media = $item->getMedia('image')->first();
                if ($media == null) {
                    if ($item->mediaImageWithDefaults != null && $item->mediaImageWithDefaults === false) {
                        $item->attributes['image'] = null;
                    } else {
                        $item->attributes['image'] = json_encode([
                            'low_quality' => config('app.url') . '/storage/default_image.jpg',
                            'high_quality' => config('app.url') . '/storage/default_image.jpg'
                        ]);
                    }
                } else {
                    $item->attributes['image'] = json_encode([
                        'low_quality' => $media->getUrl('lq'),
                        'high_quality' => $media->getUrl()
                    ]);
                }

                return;
            }
            if ($item->preserveMedia !== false) {
                $item->getMedia('image')->map(function ($media) {
                    $media->delete();
                });
            }

            if ($value === null || $value == '') {
                if ($item->mediaImageWithDefaults != null && $item->mediaImageWithDefaults === false) {
                    $item->attributes['image'] = json_encode([]);
                } else {
                    $item->attributes['image'] = json_encode([
                        'low_quality' => config('app.url') . '/storage/default_image.jpg',
                        'high_quality' => config('app.url') . '/storage/default_image.jpg'
                    ]);
                }
                return;
            }
            $media = $item
                ->addMediaFromBase64($value)
                ->usingFileName(uniqid(microtime(), true) . '.' . explode('/', Image::make($value)->mime)[1])
                ->toMediaCollection('image');
            $item->attributes['image'] = json_encode([
                'low_quality' => $media->getUrl('lq'),
                'high_quality' => $media->getUrl()
            ]);
        });
    }

    /**
     * @throws InvalidManipulation
     */
    public function registerMediaConversions(Media $media = null): void
    {
        $this->addMediaConversion('lq')
            ->quality(50)
            ->nonQueued()
            ->width(200)
            ->height(200);
    }
}
