<?php

namespace App\Http\Traits;

use Spatie\MediaLibrary\InteractsWithMedia;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileCannotBeAdded;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileDoesNotExist;
use Spatie\MediaLibrary\MediaCollections\Exceptions\FileIsTooBig;
use Spatie\MediaLibrary\MediaCollections\Exceptions\InvalidBase64Data;

trait HasFile
{
    use InteractsWithMedia;

    public static function bootHasFile()
    : void
    {
        static::created(
        /**
         * @throws FileCannotBeAdded
         * @throws FileDoesNotExist
         * @throws FileIsTooBig
         * @throws InvalidBase64Data
         */
            function ($item) {
                foreach ($item->files as $fileAttr) {
                    $file = null;
                    if (!array_key_exists($fileAttr, $item->attributes)) {
                        continue;
                    }
                    if (request()->hasFile($fileAttr)) {
                        $file = $item->addMedia(request()->file($fileAttr))->toMediaCollection($fileAttr)->getUrl();
                    }
                    $item->attributes[$fileAttr] = $file;
                }
                $item->saveQuietly();
            });
        static::updating(/**
         * @throws FileCannotBeAdded
         * @throws FileIsTooBig
         * @throws FileDoesNotExist
         * @throws InvalidBase64Data
         */ function ($item) {
            foreach ($item->files as $fileAttr) {
                $file = $item->$fileAttr;
                if (!array_key_exists($fileAttr, $item->attributes)) {
                    continue;
                }
                if (is_string($file) && $item->original[$fileAttr] == $file) {
                    $file = $item->original[$fileAttr];
                }
                else if (request()->hasFile($fileAttr)) {
                    $item->getMedia($fileAttr)->map(function ($media) {
                        $media->delete();
                    });
                    $file = $item->addMedia(request()->file($fileAttr))->toMediaCollection($fileAttr)->getUrl();
                }
                else {
                    if ($file == null || $file == '')
                        $file = null;
                    $item->getMedia($fileAttr)->map(function ($media) {
                        $media->delete();
                    });
                }
                $item->attributes[$fileAttr] = $file;
            }
        }
        );
    }
}
