<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Response;
use Illuminate\Validation\Rule;

class AddressRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        $validation = [
            'first_name' => [
                'nullable'
            ],
            'last_name' => [
                'nullable'
            ],
            'company' => [
                'nullable'
            ],
            'street_address' => [
                'nullable'
            ],
            'province' => [
                'nullable'
            ],
            'city' => [
                'nullable'
            ],
            'postal_code' => [
                'nullable'
            ],
            'phone' => [
                'nullable'
            ],
            'longitude' => [
                'required'
            ],
            'latitude' => [
                'required'
            ],
            'region' => [
                'nullable'
            ],
            'floor' => [
                'nullable'
            ],
            'district' => [
                'nullable'
            ],
            'boulevard' => [
                'nullable'
            ],
            'house' => [
                'nullable'
            ],
            'apartment' => [
                'nullable'
            ],
            'country_id' => [
                'required',
                'integer',
                Rule::exists('world_countries', 'id')->where('active', true)
            ]
        ];
        if ($this->getMethod() == 'POST') {
            return $validation;
        }
        return array_merge($validation, [
            'default' => [
                'required',
                'boolean'
            ]
        ]);
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(Response::failure($validator->errors()->first()));
    }
}
