<?php

namespace App\Http\Middleware;

use App\Services\PermissionDependencyService;
use Closure;
use Illuminate\Http\Request;

class HasPermission
{
    private $permissionDependency;

    /**
     * HasPermission constructor.
     * @param PermissionDependencyService $permissionDependency
     */
    public function __construct(PermissionDependencyService $permissionDependency)
    {
        $this->permissionDependency = $permissionDependency;
    }


    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $permission)
    {
        $user = $request->user();
        if ($user->super_admin) {
            return $next($request);
        }
        if (!$user->activated) {
            return response()->json(['error' => __('common.error_forbidden')], 403);
        }
        $userPermissions = collect($user->roles()->first()->permissions()->get()->pluck('type'));
        $this->permissionDependency->handle($userPermissions);
        return ($userPermissions->contains($permission) ?
            $next($request) :
            response()->json(['error' => __('common.error_forbidden')], 403));
    }
}
