<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ProductCategoryRequest;
use App\Models\ProductCategory;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class ProductCategoryController extends Controller
{

    public function __construct()
    {
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('has_permission:view_category')->only(['export', 'index', 'show']);
            $this->middleware('has_permission:update_category')->only(['update']);
            $this->middleware('has_permission:create_category')->only(['store']);
            $this->middleware('has_permission:delete_category')->only(['destroy']);
        }
    }

    public function index(): JsonResponse
    {
        if (request()->query('flatten') == 'true')
            return Response::success(
                ProductCategory::query()
            );

        return Response::success(
            ProductCategory::search(request()->query('word_filter'))
                ->with(['subCategoriesRecursive'])
                ->whereNull('product_category_id')
                ->active(request()->query('activated'))
                ->special(request()->query('special'))
                ->youMayLike(request()->query('you_may_like'))
        );
    }

    public function show($id): JsonResponse
    {
        return Response::success(
            ProductCategory::query()->with(['parent', 'subCategories'])->find($id)
        );
    }

    public function store(ProductCategoryRequest $request): JsonResponse
    {
        $input = $request->validated();
        $input['accepted'] = true;
        return Response::success(ProductCategory::query()->create($input)->load(['parent', 'subCategories']));

    }

    public function update(ProductCategoryRequest $request, $id): JsonResponse
    {
        $brand = ProductCategory::query()
            ->findOrFail($id);
        $brand->update($request->validated());
        return Response::success($brand->load(['parent', 'subCategories']));
    }

    public function destroy($id): JsonResponse
    {
        ProductCategory::query()->findOrFail($id)->delete();
        return Response::success(null);

    }
}
