<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Http\Requests\PaymentReportRequest;
use App\Mail\PaymentReport;
use App\Models\Order;
use App\Services\MailService;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Response;

class PaymentReportController extends Controller
{
    private $mailService;

    public function __construct(MailService $mailService)
    {
        $this->mailService = $mailService;
        if (config('app.middlewares_enabled') === true) {
            $this->middleware('auth:api');
            $this->middleware('is_member');
            $this->middleware('is_active');
        }
    }

    public function store(PaymentReportRequest $request): JsonResponse
    {
        $order = Order::withTrashed(true)->findOrFail($request['order_id']);
        $order->load([
            'user'
            , 'delivery'
            , 'coupon'
            , 'billingAddress'
            , 'shippingAddress.city'
            , 'seller'
            , 'payment'
            , 'deliveryOption'
            , 'orderItems.product'
        ]);
        $this->mailService->sendToUser($order->user, new PaymentReport($order, $request['tap_charge_id'], $request['charge_token'], $request['status']));
        return Response::success(null);
    }
}
